<?php
session_start();

// Check if the user is authenticated
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    header('Location: index.php');
    exit;
}

// Handle image upload
if (isset($_FILES['image']) && $_FILES['image']['error'] == UPLOAD_ERR_OK) {
    $image_name = $_FILES['image']['name'];
    $image_tmp_name = $_FILES['image']['tmp_name'];
    $image_type = $_FILES['image']['type'];

    // Check if the uploaded file is an image
    if (strpos($image_type, 'image') !== false) {
        // Save the image to the server
        $upload_dir = 'uploads/';
        $image_path = $upload_dir . $image_name;
        move_uploaded_file($image_tmp_name, $image_path);
    }
}

// Handle image deletion
if (isset($_POST['delete_image']) && $_POST['delete_image'] !== '') {
    $image_path = $_POST['delete_image'];
    if (file_exists($image_path)) {
        unlink($image_path);
    }
}

// Display the image upload form
?>



<!DOCTYPE html>
<html>
<head>
	<title>Password Protected Message Board</title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
	
		<style>
		.container {
			margin-top: 50px;
		}
	</style> 
	<style>
.ad-space {
    background-color: gray;
    border: 1px solid #ccc;
    padding: 10px;
    font-size: 18px;
    font-weight: bold;
    text-align: center;
}

.uploads {
    background-color: white;
    border: 1px dotted black ;
    padding: 10px;
    font-size: 18px;
    font-weight: bold;
    text-align: center;
}


</style>

	</head>
	<body>
	
	<div class="container">


<?php
$adText = "UPLOADS";
?>


	<div class="ad-space"><?php echo $adText; ?> </div>	 <a href="index.php">Home</a> | <a href="logout.php">Logout</a>
		
		<br><br>
		<div class="uploads">

<form method="post" enctype="multipart/form-data">
    <input type="file" class="btn" style="width:400px" name="image">
    <button class="btn btn-success" type="submit">Upload Image</button>
</form>

<?php
// Display the uploaded images
$upload_dir = 'uploads/';
$images = glob($upload_dir . '*.{jpg,jpeg,png,gif}', GLOB_BRACE);
?>

<br><br>
<!-- <div style="display: flex; flex-wrap: wrap;">
   
        <div style="margin-right: 10px;">
            <img src="<?php echo $image; ?>" width="100">
            <form method="post">
                <input type="hidden" name="delete_image" value="<?php echo $image; ?>">
                <button class="btn btn-danger" type="submit">Delete</button>
            </form>
        </div>
   
</div> !-->


<div class="card-deck">
    <?php foreach ($images as $image) { ?>
        <div class="card">
            <img src="<?php echo $image; ?>" class="card-img-top" width="100">
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="delete_image" value="<?php echo $image; ?>">
                    <button type="submit" class="btn btn-danger">Delete Image</button>
                </form>
            </div>
        </div>
    <?php } ?>
</div>

</div>
</body>
