<?php
// Check if the "uploads" directory already exists
if (is_dir('uploads')) {
    // If it exists, display a message and exit
    echo "<div class='container'>";
    echo "Installation already completed. Welcome to the PressWireNetwork.";
    echo "</div>";
    exit; // Stop further execution
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Form</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
</head>
<body>
    <div class="container">
        <h1 class="mt-5">Installation Form</h1>
        <form method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="logo" class="form-label">Upload Logo:</label>
                <input type="file" name="logo" class="form-control" id="logo">
            </div>
            <div class="mb-3">
                <label for="company_name" class="form-label">Company Name:</label>
                <input type="text" name="company_name" class="form-control" id="company_name">
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js" integrity="sha384-yVHktdZj3VylMmkHJ4EvBfFjqWg2bifRqFVE5KiFZBNm5gFfL3wFNYXHrHS3Hlp+" crossorigin="anonymous"></script>

    <!-- JavaScript Progress Bar -->
    <script type='text/javascript'>
        function updateProgress(perc) {
            document.getElementById('info').innerHTML = perc + '%';
            document.getElementById('prog').value = perc;
        }
    </script>
</body>
</html>

<?php

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Process form submission

    // Check if logo file is uploaded
    if(isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        // Handle logo file upload
        $logoFileName = $_FILES['logo']['name'];
        $logoTmpName = $_FILES['logo']['tmp_name'];
        
        // Extract file extension
        $extension = pathinfo($logoFileName, PATHINFO_EXTENSION);

        // Rename the file to "logo" with the original extension
        $newLogoFileName = 'logo.' . $extension;
        
        move_uploaded_file($logoTmpName, $logoFileName);
    }

    // Handle company name text file
    $companyName = $_POST['company_name'];
    file_put_contents('company_name.txt', $companyName);

// added on 8th april 2024

// If output buffer flushing does not work, web-search for reasons your PHP/web server setup may need to be adjusted
//header('X-Accel-Buffering: no');
if (ob_get_level() == 0) ob_start();

// Create JavaScript progress bar
echo "<html>
<head>
    <script type='text/javascript'>
        function updateProgress(perc) {
            document.getElementById('info').innerHTML = perc + '%';
            document.getElementById('prog').value = perc;
        }
    </script>
</head>
<body>
  <div class='container'><br>
    <p>Copying Files</p>
    <progress id='prog' value='0' max='100.0'></progress> <span id='info'>0%</span> 
    </div><br>";

// Flush the progress bar
ob_flush();
flush(); 
 
// Callback Function for later
function progressCallback($resource, $download_size, $downloaded_size, $upload_size, $uploaded_size)
{
    static $previousProgress = 0;
    if ($download_size != 0) {
        $progress = round($downloaded_size * 100 / $download_size);
        if ($progress > $previousProgress) {
            $previousProgress = $progress;
            // Update JavaScript progress bar to show download progress
            echo "<script>updateProgress('$progress');</script>";
            ob_flush();
            flush();
        } 
    }
}
// added on 8th april 2024 close








    // Start the cURL
    $targetFile = fopen('uploads.tar.gz', 'w');
    $ch = curl_init('https://presswirenetwork.com/networkfiles/uploads.tar.gz');
    curl_setopt_array($ch, array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_NOPROGRESS => false,
        CURLOPT_PROGRESSFUNCTION => 'progressCallback',
        CURLOPT_FILE => $targetFile
    ));
    curl_exec($ch);
    fclose($targetFile);

    // Proceed with installation
    proceedWithInstallation();
} 

function proceedWithInstallation() {
    // If we get here, the download has completed
    echo "<script>document.getElementById('info').innerHTML = '<br>Files Copied..Please Wait..Extracting Now..<br>'; </script>";

    ob_flush();
    flush();

    // Extract the tar.gz file
    $destinationFolder = './';
    $localTarFile = $destinationFolder . 'uploads.tar.gz';
    $archive = new PharData($localTarFile);

    $archive->extractTo($destinationFolder);
    echo ' <div class="container">';
    echo 'Archive extracted successfully.<br>';

    // Remove the tar.gz file
    unlink($localTarFile);

    echo 'Installation completed. Welcome to the PressWireNetwork.<br>';

    // Display clickable link to index.php
    $indexFile = $destinationFolder . 'index.php';
    echo 'You can <a href="' . $indexFile . '">click here</a> to view the installation.';
    echo '</div>';
    // Flush just to be sure
    ob_flush();
    flush();
}

?>
